import axios from 'axios';

const API_BASE_URL = '/api';

// Create axios instance with base URL
const apiClient = axios.create({
  baseURL: API_BASE_URL,
  headers: {
    'Content-Type': 'application/json'
  }
});

// Categories API
export const categoriesAPI = {
  // Get all categories
  getAllCategories: async (parentId = null) => {
    const params = parentId ? { parent_id: parentId } : {};
    const response = await apiClient.get('/categories', { params });
    return response.data;
  },
  
  // Get category by slug
  getCategoryBySlug: async (slug) => {
    const response = await apiClient.get(`/categories/${slug}`);
    return response.data;
  }
};

// Tutorials API
export const tutorialsAPI = {
  // Get all tutorials with optional filters
  getAllTutorials: async (params = {}) => {
    const response = await apiClient.get('/tutorials', { params });
    return response.data;
  },
  
  // Get tutorial by slug
  getTutorialBySlug: async (slug) => {
    const response = await apiClient.get(`/tutorials/${slug}`);
    return response.data;
  },
  
  // Search tutorials
  searchTutorials: async (query) => {
    console.log("==== ==== ====")
    console.log("==== SEARCH ====")
    console.log("==== ==== ====")
    const response = await apiClient.get('/tutorials/search', { 
      params: { q: query }
    });
    return response.data;
  }
};

export default {
  categories: categoriesAPI,
  tutorials: tutorialsAPI
};