import React from 'react';
import { Link } from 'react-router-dom';
import styled from 'styled-components';
import { FiArrowLeft } from 'react-icons/fi';

const NotFoundContainer = styled.div`
  max-width: 800px;
  margin: 0 auto;
  padding: 3rem 1rem;
  text-align: center;
`;

const NotFoundTitle = styled.h1`
  font-size: 3rem;
  margin-bottom: 1rem;
  color: var(--primary-color);
`;

const NotFoundCode = styled.div`
  font-size: 8rem;
  font-weight: bold;
  color: var(--text-light);
  opacity: 0.2;
  margin-bottom: 2rem;
`;

const NotFoundDescription = styled.p`
  font-size: 1.2rem;
  margin-bottom: 2rem;
  color: var(--text-light);
`;

const BackButton = styled(Link)`
  display: inline-flex;
  align-items: center;
  gap: 0.5rem;
  padding: 0.75rem 1.5rem;
  background-color: var(--primary-color);
  color: white;
  border-radius: var(--radius);
  font-weight: 600;
  transition: all var(--transition-speed);
  
  &:hover {
    background-color: var(--primary-hover);
    transform: translateY(-2px);
  }
`;

const NotFoundPage = () => {
  return (
    <NotFoundContainer>
      <NotFoundCode>404</NotFoundCode>
      <NotFoundTitle>Page Not Found</NotFoundTitle>
      <NotFoundDescription>
        The page you're looking for doesn't exist or has been moved.
      </NotFoundDescription>
      <BackButton to="/">
        <FiArrowLeft /> Back to Home
      </BackButton>
    </NotFoundContainer>
  );
};

export default NotFoundPage;