import React, { useState } from 'react';
import { Routes, Route } from 'react-router-dom';
import styled from 'styled-components';
import { ThemeProvider } from './contexts/ThemeContext';
import { UserProgressProvider } from './contexts/UserProgressContext';

// Layout Components
import Header from './components/layout/Header';
import Sidebar from './components/layout/Sidebar';
import Footer from './components/layout/Footer';

// Pages
import HomePage from './pages/HomePage';
import CategoryPage from './pages/CategoryPage';
import TutorialPage from './pages/TutorialPage';
import SearchResultsPage from './pages/SearchResultsPage';
import NotFoundPage from './pages/NotFoundPage';

const AppContainer = styled.div`
  display: flex;
  flex-direction: column;
  min-height: 100vh;
  background-color: var(--bg-color);
  color: var(--text-color);
  transition: background-color var(--transition-speed), color var(--transition-speed);
`;

const MainContent = styled.main`
  margin-top: var(--header-height);
  margin-left: ${props => props.sidebarOpen ? 'var(--sidebar-width)' : '0'};
  flex: 1;
  padding: 1.5rem;
  transition: margin-left var(--transition-speed);
  
  @media (max-width: 768px) {
    margin-left: 0;
    padding: 1rem;
  }
`;

const App = () => {
  const [sidebarOpen, setSidebarOpen] = useState(true);
  
  const toggleSidebar = () => {
    setSidebarOpen(!sidebarOpen);
  };
  
  return (
    <ThemeProvider>
      <UserProgressProvider>
        <AppContainer>
          <Header toggleSidebar={toggleSidebar} sidebarOpen={sidebarOpen} />
          <Sidebar isOpen={sidebarOpen} />
          <MainContent sidebarOpen={sidebarOpen}>
            <Routes>
              <Route path="/" element={<HomePage />} />
              <Route path="/category/:slug" element={<CategoryPage />} />
              <Route path="/tutorial/:slug" element={<TutorialPage />} />
              <Route path="/search" element={<SearchResultsPage />} />
              <Route path="*" element={<NotFoundPage />} />
            </Routes>
          </MainContent>
          <Footer sidebarOpen={sidebarOpen} />
        </AppContainer>
      </UserProgressProvider>
    </ThemeProvider>
  );
};

export default App;